#include <iostream>
#include <vector>
#include <list>
#include <unordered_map>
#include <algorithm>
#include <utility>
#include <cstring>
#include <map>
using namespace std;

vector<int> BFS(int index, unordered_map<int, vector<int>> lista, vector<bool> posecene)
{
	list<int> queue;
	queue.clear();
	
	vector<int> res;
	res.clear();
	
	posecene[index] = true;
	queue.push_back(index);
	
	while(!queue.empty())
	{
		index = queue.front();
		res.push_back(index);
		queue.pop_front();
		
		for(auto it : lista[index])
		{
			if(!posecene[it])
			{
				queue.push_back(it);
				posecene[it] = true;
			}
		}
	}
	
	return res;
}

int main()
{
	int n = 0;
	cin >> n;
	
	unordered_map<int, vector<int>> lista;
	
	lista[1].push_back(0);
	
	int u, v;
	
	for(int i = 0 ; i < n-1; i++)
	{
		cin >> u >> v;
		lista[v].push_back(u);
	}
	
	map<int, bool> B;
	
	B[0] = true;
	bool b = true;
	
	for(int i = 1; i <= n; i++)
	{
		cin >> b;
		B[i] = b;
	}
			
	int uslov[n];
	for(int i = 0; i < n; i++)
		cin >> uslov[i];
	
	vector<int> res;
	vector<int> pom;
	pom.resize(n);
	vector<bool> posecene(n, false);
	
	for(int i = 1; i <= n; i++)
	{	
		pom.clear();
		
		if(uslov[i-1] != 0)
			B[uslov[i-1]] = !B[uslov[i-1]];
		
		pom = BFS(i, lista, posecene);
		
		pom.erase(pom.begin());
		
		int count = 0;
		
		for(int j = 0; j < pom.size(); j++)
		{
			if(B[pom[j]] == false)
				count++;
			
			if(B[pom[j]] == true)
				count = 0;
				
			if(count == i)
			{
				pom.resize(j);
				break;
			}
		}
			
		if(i == 1)
		{
			res.push_back(1);
			continue;
		}
			
		else
		{
			int j = pom[pom.size()-1];
			if(j != 0)
				res.push_back(-1);
				
			if(j == 0)
			{
				if(pom.size() < i)
					res.push_back(1);
				else
				{
					if(pom.size() % i != 0)
						res.push_back(pom.size()/i+1);
					else
						res.push_back(pom.size()/i);
				}
			}			
		}
	}
	
	for(int i = 0; i < res.size(); i++)
		cout << res[i] << " ";
}